// Replacer.cpp : implementation file
//

#include "stdafx.h"
#include "packager3.h"
#include "Replacer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReplacer dialog


CReplacer::CReplacer(CWnd* pParent /*=NULL*/)
	: CDialog(CReplacer::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReplacer)
	m_NewName = _T("");
	//}}AFX_DATA_INIT
}


void CReplacer::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReplacer)
	DDX_Text(pDX, IDC_NEWNAME, m_NewName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CReplacer, CDialog)
	//{{AFX_MSG_MAP(CReplacer)
		ON_WM_DROPFILES()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_REPLACE_OK, OnReplaceOk)
	ON_BN_CLICKED(IDC_REPLACE_CANCEL, OnReplaceCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CReplacer message handlers

void CReplacer::OnDropFiles(HDROP hDropInfo) 
{
	UINT NbFiles;
	char *Buff;
	UINT FileNameLen;

	NbFiles = DragQueryFile(hDropInfo, 0xFFFFFFFF, NULL, 0);
	if (NbFiles != 1)
	{
		MessageBox("You should drag'n'drop only ONE file", "Oupz", MB_OK);
		return;
	}

	FileNameLen = DragQueryFile(hDropInfo, 0, NULL, 0) +1;
	Buff = (char*)malloc(FileNameLen);
	DragQueryFile(hDropInfo, 0, Buff, FileNameLen);
	if (GetFileAttributes(Buff) & FILE_ATTRIBUTE_DIRECTORY)
	{
		MessageBox("Why a folder ???", "Oupz", MB_OK);
		free(Buff);
		return;
	}

	m_NewName = Buff;
	UpdateData(FALSE);
	free(Buff);
}

void CReplacer::OnOK()
{

}

void CReplacer::OnCancel()
{

}

void CReplacer::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	EndDialog(0);
	CDialog::OnClose();
}

void CReplacer::OnReplaceOk() 
{
	EndDialog(0);	
}

CString& CReplacer::GetNewName()
{
	return m_NewName;
}

void CReplacer::OnReplaceCancel() 
{
	m_NewName = "";
	EndDialog(0);
}
